# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # This batched background migration is EE-only, see
    # ee/lib/ee/gitlab/background_migration/fix_corrupted_scanner_ids_of_vulnerability_reads.rb
    # for the actual migration code.
    #
    # This batched background migration will update any
    # vulnerability_read that has a scanner_id that differs from the
    # related vulnerability_occurrence.scanner_id. The
    # vulnerability_occurrence.scanner_id is the correct value, so the
    # mismatched vulnerability_read will be updated to the
    # vulnerability_occurrence.scanner_id value
    class FixCorruptedScannerIdsOfVulnerabilityReads < BatchedMigrationJob
      feature_category :vulnerability_management

      def perform; end
    end
  end
end

Gitlab::BackgroundMigration::FixCorruptedScannerIdsOfVulnerabilityReads.prepend_mod
