# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position,no-name-in-module

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    AnalyzeInput,
    AnalyzeResult,
    ArrayField,
    AudioVisualContent,
    AudioVisualContentSegment,
    BooleanField,
    ContentAnalyzer,
    ContentAnalyzerAnalyzeOperationStatus,
    ContentAnalyzerConfig,
    ContentAnalyzerOperationStatus,
    ContentCategoryDefinition,
    ContentField,
    ContentFieldDefinition,
    ContentFieldSchema,
    ContentSpan,
    ContentUnderstandingDefaults,
    CopyAuthorization,
    DateField,
    DocumentAnnotation,
    DocumentAnnotationComment,
    DocumentBarcode,
    DocumentCaption,
    DocumentChartFigure,
    DocumentContent,
    DocumentContentSegment,
    DocumentFigure,
    DocumentFootnote,
    DocumentFormula,
    DocumentHyperlink,
    DocumentLine,
    DocumentMermaidFigure,
    DocumentPage,
    DocumentParagraph,
    DocumentSection,
    DocumentTable,
    DocumentTableCell,
    DocumentWord,
    IntegerField,
    JsonField,
    KnowledgeSource,
    LabeledDataKnowledgeSource,
    MediaContent,
    NumberField,
    ObjectField,
    RecordMergePatchUpdate,
    StringField,
    SupportedModels,
    TimeField,
    TranscriptPhrase,
    TranscriptWord,
    UsageDetails,
)

from ._enums import (  # type: ignore
    AnnotationFormat,
    ChartFormat,
    ContentAnalyzerStatus,
    ContentFieldType,
    DocumentAnnotationKind,
    DocumentBarcodeKind,
    DocumentFigureKind,
    DocumentFormulaKind,
    DocumentTableCellKind,
    GenerationMethod,
    KnowledgeSourceKind,
    LengthUnit,
    MediaContentKind,
    OperationState,
    ProcessingLocation,
    SemanticRole,
    TableFormat,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AnalyzeInput",
    "AnalyzeResult",
    "ArrayField",
    "AudioVisualContent",
    "AudioVisualContentSegment",
    "BooleanField",
    "ContentAnalyzer",
    "ContentAnalyzerAnalyzeOperationStatus",
    "ContentAnalyzerConfig",
    "ContentAnalyzerOperationStatus",
    "ContentCategoryDefinition",
    "ContentField",
    "ContentFieldDefinition",
    "ContentFieldSchema",
    "ContentSpan",
    "ContentUnderstandingDefaults",
    "CopyAuthorization",
    "DateField",
    "DocumentAnnotation",
    "DocumentAnnotationComment",
    "DocumentBarcode",
    "DocumentCaption",
    "DocumentChartFigure",
    "DocumentContent",
    "DocumentContentSegment",
    "DocumentFigure",
    "DocumentFootnote",
    "DocumentFormula",
    "DocumentHyperlink",
    "DocumentLine",
    "DocumentMermaidFigure",
    "DocumentPage",
    "DocumentParagraph",
    "DocumentSection",
    "DocumentTable",
    "DocumentTableCell",
    "DocumentWord",
    "IntegerField",
    "JsonField",
    "KnowledgeSource",
    "LabeledDataKnowledgeSource",
    "MediaContent",
    "NumberField",
    "ObjectField",
    "RecordMergePatchUpdate",
    "StringField",
    "SupportedModels",
    "TimeField",
    "TranscriptPhrase",
    "TranscriptWord",
    "UsageDetails",
    "AnnotationFormat",
    "ChartFormat",
    "ContentAnalyzerStatus",
    "ContentFieldType",
    "DocumentAnnotationKind",
    "DocumentBarcodeKind",
    "DocumentFigureKind",
    "DocumentFormulaKind",
    "DocumentTableCellKind",
    "GenerationMethod",
    "KnowledgeSourceKind",
    "LengthUnit",
    "MediaContentKind",
    "OperationState",
    "ProcessingLocation",
    "SemanticRole",
    "TableFormat",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
